unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, ComCtrls, Buttons, ExtCtrls, StdCtrls;

type
  TFormMain = class(TForm)
    StatusBar1: TStatusBar;
    DBGrid1: TDBGrid;
    Panel2: TPanel;
    btnCLOSE: TBitBtn;
    btnIlosc: TBitBtn;
    procedure btnIloscClick(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);

  private
    procedure Daj_ilosc_osob_ur_po();
  public

  end;

var
  FormMain: TFormMain;

implementation
{$R *.dfm}
Uses
   DData,
   DataModule;

procedure TFormMain.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TFormMain.btnIloscClick(Sender: TObject);
begin
	Daj_ilosc_osob_ur_po();
end;

procedure TFormMain.Daj_ilosc_osob_ur_po();
var
   dataur  : TDateTime;
   res     : TMOdalResult;
   ilosc   : Integer;

begin
   DlgData := TDlgData.Create(Self);
   Res     := DlgData.ShowModal();

   if Res = mrOK then
   begin
      dataur := DlgData.dtpData.Date;

      with DM.P_CZYTELNICY do
      begin
         ParamByName('DATAUR').AsDAteTime := dataur;
         ExecProc();
         ilosc := 0;
         ilosc := ParamByName('WYNIK').AsInteger;
         ShowMessage('Data ur ' + DateToStr(dataur) + #10#13 +
                     'Ilo osb urodzonych po tym dniu: ' + IntToStr(ilosc));
      end;
   end;
end;

end.
